/*
 * Decompiled with CFR 0.152.
 */
package util;

import core.GameWindow;
import core.MinionInvaders;
import core.Sprite;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.opengl.Texture;
import org.newdawn.slick.opengl.TextureLoader;
import org.newdawn.slick.util.ResourceLoader;
import util.AudioManager;

public class ResourceManager {
    private static final ResourceManager single = new ResourceManager();
    private GameWindow window;
    private MinionInvaders game;
    private HashMap<String, Audio> soundMap;
    private HashMap<String, Audio> musicMap;

    public static ResourceManager get() {
        return single;
    }

    private ResourceManager() {
    }

    public void setGame(MinionInvaders game) {
        this.game = game;
    }

    public MinionInvaders getGame() {
        return this.game;
    }

    public GameWindow getGameWindow() {
        if (this.window == null) {
            this.window = new GameWindow();
        }
        return this.window;
    }

    public Sprite getSprite(String ref) {
        if (this.window == null) {
            throw new RuntimeException("Attempt to retrieve sprite before game window was created");
        }
        return new Sprite(this.window, ref);
    }

    public Texture getTexture(String key) {
        try {
            return TextureLoader.getTexture((String)"PNG", (InputStream)ResourceLoader.getResourceAsStream((String)("resources/sprites/" + key + ".png")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public URL getResource(String path) {
        return this.getClass().getResource(path);
    }

    public Dimension getDimension() {
        return this.game.getDimension();
    }

    public void initAudio() {
        this.soundMap = new HashMap();
        this.musicMap = new HashMap();
        this.musicMap.put("lol_retro", AudioManager.get().initMusic("lol_retro"));
        this.soundMap.put("level_win", AudioManager.get().initSound("level_win"));
        this.soundMap.put("level_lose", AudioManager.get().initSound("level_lose"));
        this.soundMap.put("minion_shot_hit", AudioManager.get().initSound("minion_shot_hit"));
        this.soundMap.put("sona_die", AudioManager.get().initSound("sona_die"));
        this.soundMap.put("sona_shot", AudioManager.get().initSound("sona_shot"));
        this.soundMap.put("sona_shot_hit", AudioManager.get().initSound("sona_shot_hit"));
        this.soundMap.put("sona_powerchord", AudioManager.get().initSound("sona_powerchord"));
        this.soundMap.put("sona_powerchord_hit", AudioManager.get().initSound("sona_powerchord_hit"));
        this.soundMap.put("sona_abilityQ", AudioManager.get().initSound("sona_abilityQ"));
        this.soundMap.put("sona_abilityW", AudioManager.get().initSound("sona_abilityW"));
        this.soundMap.put("sona_abilityE", AudioManager.get().initSound("sona_abilityE"));
        this.soundMap.put("sona_abilityR", AudioManager.get().initSound("sona_abilityR"));
        this.soundMap.put("sona_abilityD", AudioManager.get().initSound("sona_abilityD"));
        this.soundMap.put("sona_abilityF", AudioManager.get().initSound("sona_abilityF"));
        this.soundMap.put("lux_win", AudioManager.get().initSound("lux_win"));
        this.soundMap.put("lux_win2", AudioManager.get().initSound("lux_win2"));
        this.soundMap.put("lux_die", AudioManager.get().initSound("lux_die"));
        this.soundMap.put("lux_shot", AudioManager.get().initSound("lux_shot"));
        this.soundMap.put("lux_shot_hit", AudioManager.get().initSound("lux_shot_hit"));
        this.soundMap.put("lux_passive_hit", AudioManager.get().initSound("lux_passive_hit"));
        this.soundMap.put("lux_abilityQ", AudioManager.get().initSound("lux_abilityQ"));
        this.soundMap.put("lux_abilityQ2", AudioManager.get().initSound("lux_abilityQ2"));
        this.soundMap.put("lux_abilityQ_hit", AudioManager.get().initSound("lux_abilityQ_hit"));
        this.soundMap.put("lux_abilityW", AudioManager.get().initSound("lux_abilityW"));
        this.soundMap.put("lux_abilityW2", AudioManager.get().initSound("lux_abilityW2"));
        this.soundMap.put("lux_abilityW_hit", AudioManager.get().initSound("lux_abilityW_hit"));
        this.soundMap.put("lux_abilityR", AudioManager.get().initSound("lux_abilityR"));
        this.soundMap.put("lux_abilityR2", AudioManager.get().initSound("lux_abilityR2"));
        this.soundMap.put("lux_abilityR3", AudioManager.get().initSound("lux_abilityR3"));
        this.soundMap.put("sivir_win", AudioManager.get().initSound("sivir_win"));
        this.soundMap.put("sivir_die", AudioManager.get().initSound("sivir_die"));
        this.soundMap.put("sivir_shot", AudioManager.get().initSound("sivir_shot"));
        this.soundMap.put("sivir_shot_hit", AudioManager.get().initSound("sivir_shot_hit"));
        this.soundMap.put("sivir_abilityQ", AudioManager.get().initSound("sivir_abilityQ"));
        this.soundMap.put("sivir_abilityQ_hit", AudioManager.get().initSound("sivir_abilityQ_hit"));
        this.soundMap.put("sivir_abilityE", AudioManager.get().initSound("sivir_abilityE"));
        this.soundMap.put("sivir_abilityR", AudioManager.get().initSound("sivir_abilityR"));
        this.soundMap.put("ezreal_ulti", AudioManager.get().initSound("ezreal_ulti"));
        this.soundMap.put("ezreal_ulti_hit", AudioManager.get().initSound("ezreal_ulti_hit"));
        this.soundMap.put("ezreal_ulti_finished", AudioManager.get().initSound("ezreal_ulti_finished"));
        this.soundMap.put("soraka_ulti", AudioManager.get().initSound("soraka_ulti"));
    }

    public boolean isSoundPlaying(String key) {
        if (!this.soundMap.containsKey(key)) {
            System.err.println("Trying to access illegal audio key: " + key);
            return false;
        }
        return this.soundMap.get(key).isPlaying();
    }

    public void stopSound(String key) {
        if (!this.soundMap.containsKey(key)) {
            System.err.println("Trying to access illegal audio key: " + key);
            return;
        }
        Audio audio = this.soundMap.get(key);
        if (audio.isPlaying()) {
            audio.stop();
        }
    }

    public void playSound(String key) {
        this.playSound(key, false);
    }

    public void playSound(String key, boolean doNothingIfRunning) {
        if (!this.soundMap.containsKey(key)) {
            System.err.println("Trying to access illegal audio key: " + key);
            return;
        }
        Audio audio = this.soundMap.get(key);
        if (doNothingIfRunning && audio.isPlaying()) {
            return;
        }
        AudioManager.get().playSound(audio);
    }

    public void playMusic(String key) {
        this.playMusic(key, true);
    }

    public void playMusic(String key, boolean doNothingIfRunning) {
        if (!this.musicMap.containsKey(key)) {
            System.err.println("Trying to access illegal audio key: " + key);
            return;
        }
        Audio audio = this.musicMap.get(key);
        if (doNothingIfRunning && audio.isPlaying()) {
            return;
        }
        AudioManager.get().playMusic(audio);
    }

    public void cleanUp() {
        AudioManager.get().cleanUp();
        if (this.window != null) {
            this.window.cleanUp();
            this.window = null;
        }
    }
}

